// 获取动态ID
function mc_get_id() {
    // 加随机数 前缀
    return 'mc_item' + new Date().getTime() + (Math.random() * 1000).toFixed(0);
}

// 传递的函数
var g_str_attr_lab_val_chg = 'on_val_chg';

// 标签栏/静态文本框
function mc_ui_lab() {
    var mc_lab_id = ""; //id
    var mc_lab_val = ""; //值
    var mc_lab_title = ""; //title值
    var ary_class = ['mc_lab']; //class类
    var ary_style = []; //样式 [[width,20px],[height,20px]...]

    // 设置样式 宽
    this.set_style_width = function (width) {
        if ('number' !== typeof width) {
            return false;
        }
        ary_style.push(['width', width]);
    };

    // 设置高
    this.set_style_height = function (height) {
        if ('number' !== typeof height) {
            return false;
        }
        ary_style.push(['height', height]);
    };

    // 设置字体颜色
    this.set_style_color = function (color) {
        if ('string' !== typeof color) {
            return false;
        }
        ary_style.push(['color', color]);
    };

    // 设置水平方向对其方式 left right center
    this.set_style_direction = function (direction) {
        if ('string' !== typeof direction) {
            return false;
        }
        ary_style.push(['text-align', direction]);
    };

    // 设置垂直方向偏移 number
    this.set_style_vertical = function (vertical) {
        if ('number' !== typeof vertical) {
            return false;
        }
        ary_style.push(['line-height', vertical]);
    };

    // 设置添加class类 
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
    };

    // 移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
    };

    // 设置lab的内容
    this.set_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        mc_lab_val = str_val;
    };

    // 获得lab的内容
    this.get_val = function () {
        if (0 === mc_lab_val.length) {
            return null;
        }
        return mc_lab_val;
    };

    // 设置lab的内容
    this.set_dom_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        $("#" + mc_lab_id).text(str_val);
    };

    // 获得lab的内容 
    this.get_dom_val = function () {
        if (0 === mc_lab_val.length) {
            return null;
        }
        return $("#" + mc_lab_id).html();
    };

    // 获得lab的ID
    this.get_id = function () {
        if (0 === mc_lab_id.length) {
            return null;
        }
        return mc_lab_id;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_lab_title = str_title;
    };

    // 创建标签 
    this.get_html_txt = function () {
        mc_lab_id = mc_get_id();
        var str_class_list = '';

        // 类数组转化为字符串
        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + ' ';
        }
        str_class_list = str_class_list.trim();
        // 样式数组转化为字符串 background: red;color: aqua;
        if (0 !== ary_style.length) {
            var str_style_list = '';
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ':' + ary_style[idx_style][1] + ';'
            }
        }

        // var str_tip = '';
        // if (0 !== mc_lab_title.lengtht) {
        //   str_tip += mc_lab_title + ' ';
        // }
        // if (0 !== str_style_list.length) {
        //   str_tip += str_style_list + ' ';
        // }
        return str_dom_txt = "<div class='" + str_class_list + "' id='" + mc_lab_id + "' title = '" + mc_lab_title + "' style='" + str_style_list + "'>" + mc_lab_val + "</div>";
    };
};

// 编辑框
function mc_ui_edit() {
    var mc_edit_id = '';
    var mc_edit_val = '';
    var mc_edit_title = '';
    var mc_edit_type = ""; //数据类型
    var mc_edit_max = Math.pow(2, 32) - 1; //默认最大值
    var mc_edit_min = -9999; //默认最小值
    var ary_class = ['mc_edit'];
    var ary_style = [];

    // 数值改变触发 返回当前id与当前值 接受传递的函数
    this.on_val_chg = function () {};

    // 设置宽
    this.set_style_width = function (width) {
        if ('number' !== typeof width) {
            return false;
        }
        ary_style.push(['width', width]);
    };

    // 设置高
    this.set_style_height = function (height) {
        if ('number' !== typeof height) {
            return false;
        }
        ary_style.push(['height', height]);
    };

    // 设置字体颜色
    this.set_style_color = function (color) {
        if ('string' !== typeof color) {
            return false;
        }
        ary_style.push(['color', color]);
    };

    // 设置水平方向对其方式 left right center
    this.set_style_direction = function (direction) {
        if ('string' !== typeof direction) {
            return false;
        }
        ary_style.push(['text-align', direction]);
    };

    // 设置添加class类 
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
    };

    // 移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_class.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
    };

    // 设置编辑框的内容
    this.set_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        mc_edit_val = str_val;
    };

    // 获得编辑框的内容
    this.get_val = function () {
        if (0 === mc_edit_val.length) {
            return null;
        }
        return mc_edit_val;
    };

    // 设置编辑框的内容
    this.set_dom_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        $("#" + mc_edit_id).val(str_val);
    };

    // 获得编辑框的内容
    this.get_dom_val = function () {
        if (0 === mc_edit_val.length) {
            return null;
        }
        return $("#" + mc_edit_id).val();
    };

    // 获得编辑框的ID
    this.get_id = function () {
        if (0 === mc_edit_id.length) {
            return null;
        }
        return mc_edit_id;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_edit_title = str_title;
    };

    // 设置数据类型 
    this.set_type = function (str_type) {
        if ('string' !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        mc_edit_type = str_type;
    };

    // 设置输入的最大值
    this.set_max_val = function (cui_max_val) {
        if ('string' !== typeof cui_max_val || '' === cui_max_val) {
            return false;
        }
        mc_edit_max = cui_max_val;
    };

    // 设置输入的最小值
    this.set_min_val = function (cui_min_val) {
        if ('string' !== typeof cui_min_val || '' === cui_min_val) {
            return false;
        }
        mc_edit_min = cui_min_val;
    };

    // 创建标签
    this.get_html_txt = function () {
        mc_edit_id = mc_get_id();
        var str_class_list = '';
        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + ' ';
        }
        str_class_list = str_class_list.trim();

        if (0 !== ary_style.length) {
            var str_style_list = '';
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ':' + ary_style[idx_style][1] + ';'
            }
            str_style_list = str_style_list.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = '';
        if (typeof this.on_val_chg === 'function') {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_name(this.on_val_chg) + "'";
        }
        return str_dom_txt = "<input type='text' " + str_val_chg_callback_attr + " id='" + mc_edit_id + "' class='" + str_class_list + "' title = '" + mc_edit_title + "' style='" + str_style_list + "' cui_max_val=" + mc_edit_max + " cui_min_val=" + mc_edit_min + " value='" + mc_edit_val + "' onclick='this.select()' onkeyup='mc_setinp_" + mc_edit_type + "(this)'/>"
    };
};

// 步进编辑框 必须创建在class类为mc_edt_inp_wrap的元素中 
function mc_ui_step_edit() {
    var mc_step_id = '';
    var mc_step_val = 0;
    var mc_step_title = '';
    var mc_step_type = "";
    var mc_step_max = Math.pow(2, 32) - 1; //默认最大值
    var mc_step_min = -9999; //默认最小值
    var mc_step = 1; //默认步进值
    var ary_class = [
        [],
        ['mc_step_inp']
    ]; //[[btnClass],[inpClass]]
    var ary_style = []; //inp样式

    // 数值改变触发 返回当前id与当前值 接受传递的函数
    this.on_val_chg = function () {};

    // 设置宽
    this.set_style_width = function (width) {
        if ('number' !== typeof width) {
            return false;
        }
        ary_style.push(['width', width]);
    };

    // 设置高
    this.set_style_height = function (height) {
        if ('number' !== typeof height) {
            return false;
        }
        ary_style.push(['height', height]);
    };

    // 设置字体颜色
    this.set_style_color = function (color) {
        if ('string' !== typeof color) {
            return false;
        }
        ary_style.push(['color', color]);
    };

    // 给inp设置添加class类 
    this.set_addinp_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[1].push(str_css);
    };

    // 给btn设置添加class类 
    this.set_addbtn_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
    };

    // 移除inp calss类
    this.set_delinp_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[1].length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
    };

    // 移除btn calss类
    this.set_delbtn_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[0].length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
    };

    // 设置步进编辑框的内容
    this.set_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        mc_step_val = str_val;
    };

    // 获得步进编辑框的内容
    this.get_val = function () {
        if (0 === mc_step_val.length) {
            return null;
        }
        return mc_step_val;
    };

    // 设置步进编辑框的内容
    this.set_dom_val = function (str_val) {
        if ('string' !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        $("#" + mc_step_id).val(str_val);
    };

    // 获得步进编辑框的内容
    this.get_dom_val = function () {
        if (0 === mc_step_val.length) {
            return null;
        }
        return $("#" + mc_step_id).val();
    };

    // 获得步进编辑框的ID
    this.get_id = function () {
        if (0 === mc_step_id.length) {
            return null;
        }
        return mc_step_id;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_step_title = str_title;
    };

    // 设置数据类型 int整数 uint正整数 obj十六进制数 flost浮点数和整数
    this.set_type = function (str_type) {
        if ('string' !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        mc_step_type = str_type;
    };

    // 设置输入的最大值
    this.set_max_val = function (cui_max_val) {
        if ('string' !== typeof cui_max_val || '' === cui_max_val) {
            return false;
        }
        mc_step_max = cui_max_val;
    };

    // 设置输入的最小值
    this.set_min_val = function (cui_min_val) {
        if ('string' !== typeof cui_min_val || '' === cui_min_val) {
            return false;
        }
        mc_step_min = cui_min_val;
    };

    // 设置步进值
    this.set_step_val = function (cui_step) {
        if ('string' !== typeof cui_step || 0 === cui_step.length) {
            return false;
        }
        mc_step = cui_step;
    };

    // 创建标签
    this.get_html_txt = function () {
        mc_step_id = mc_get_id();
        var str_class_list_inp = '';
        var str_class_list_btn = '';

        // class类
        for (var idx_class = 0; idx_class < ary_class[1].length; idx_class++) {
            str_class_list_inp += ary_class[1][idx_class] + ' ';
        }
        str_class_list_inp = str_class_list_inp.trim();

        if (0 !== ary_class[0].length) {
            for (var idx_class = 0; idx_class < ary_class[0].length; idx_class++) {
                str_class_list_btn += ary_class[0][idx_class] + ' ';
            }
            str_class_list_btn = str_class_list_btn.trim();
        }

        // 样式
        if (0 !== ary_style.length) {
            var str_style_list = '';
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ':' + ary_style[idx_style][1] + ';'
            }
            str_style_list = str_style_list.trim();
        }

        // 接收函数处理
        var str_val_chg_callback_attr = '';
        if (typeof this.on_val_chg === 'function') {
            // on_val_chg = function(){} 接收到的函数作为属性传递 
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_name(this.on_val_chg) + "'";
        }
        return str_dom_txt = "<div class='mc_step_edit_wrap'><button cui_min_val=" + mc_step_min + "  class='mc_step_sub" + '' + str_class_list_btn + "'>-</button><input type='text' " + str_val_chg_callback_attr + " id='" + mc_step_id + "' class='flex_box_auto_size " + str_class_list_inp + "' title='" + mc_step_title + "' style='" + str_style_list + "' cui_step=" + mc_step + " value='" + mc_step_val + "' onkeyup='mc_setinp_" + mc_step_type + "(this)' /><button class='mc_step_add" + '' + str_class_list_btn + "' cui_max_val=" + mc_step_max + ">+</button></div>";
    };
};

// 复选框 必须创建在class类为mc_edt_inp_wrap的元素中 
function mc_ui_toggle() {
    var mc_checkbox_id = '';
    var mc_checkbox_title = '';
    var ary_class = ['mc_checkbox'];
    var ary_style = [];

    this.on_val_chg = function () {};

    // 设置宽
    this.set_style_width = function (width) {
        if ('number' !== typeof width) {
            return false;
        }
        ary_style.push(['width', width]);
    };

    // 设置高
    this.set_style_height = function (height) {
        if ('number' !== typeof height) {
            return false;
        }
        ary_style.push(['height', height]);
    };

    // 添加class类 
    this.set_addche_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
    };

    // 移除calss类
    this.set_delche_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
    };

    this.set_val = function (str_val) {};

    // 获得ID 
    this.get_id = function () {
        if (0 === mc_checkbox_id.length) {
            return null;
        }
        return mc_checkbox_id;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_checkbox_title = str_title;
    };

    // 创建标签
    this.get_html_txt = function () {
        mc_checkbox_id = mc_get_id();
        var str_class_list = ''; //复选框class类字串


        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + ' ';
        }
        str_class_list = str_class_list.trim();

        if (0 !== ary_style.length) {
            var str_style_list = '';
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ':' + ary_style[idx_style][1] + ';'
            }
            str_style_list = str_style_list.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = '';
        if (typeof this.on_val_chg === 'function') {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_name(this.on_val_chg) + "'";
        }
        return str_dom_txt = "<span class='mc_checkbox_box' " + str_val_chg_callback_attr + " id='" + mc_checkbox_id + "' title='" + mc_checkbox_title + "'><div class='" + str_class_list + "'>&#10003;</div></span>"
    };
};

// 滑动条 
function mc_ui_slider() {
    var mc_slider_id = '';
    var mc_slider_title = '';
    var mc_slider_max = 100; //默认最大值
    var mc_slider_min = 0; //默认最小值
    var ary_class = [
        ['mc_slider'],
        [
            ['mc_slider_thumb']
        ],
        ['mc_slider_thumb_inp']
    ]; //[[轨道],[div滑块],[inp滑块]]
    var ary_style = [
        [],
        []
    ]; //[[轨道样式],[div滑块样式]]

    // 数值改变触发 返回当前id与当前值 接受传递的函数
    this.on_val_chg = function () {};

    // 设置轨道宽
    this.set_style_width = function (width) {
        if ('number' !== typeof width) {
            return false;
        }
        ary_style[0].push(['width', width]);
    };

    // 设置轨道高
    this.set_style_height = function (height) {
        if ('number' !== typeof height) {
            return false;
        }
        ary_style[0].push(['height', height]);
    };

    // 设置轨道背景颜色
    this.set_style_color = function (color) {
        if ('string' !== typeof color) {
            return false;
        }
        ary_style[0].push(['color', color]);
    };

    // 设置滑块背景颜色
    this.set_style_thumb_color = function (color) {
        if ('string' !== typeof color) {
            return false;
        }
        ary_style[1].push(['color', color]);
    };

    // 轨道添加class类
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
    };

    // 轨道移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_class[0].length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
    };

    // div滑块添加class类
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[1].push(str_css);
    };

    // div滑块移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_class[1].length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
    };

    // inp滑块添加class类
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[2].push(str_css);
    };

    // inp滑块移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_class[2].length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[2][idx_css] === str_css) {
                ary_class[2].splice(idx_css, 1);
                break;
            }
        }
    };

    this.set_val = function (str_val) {};

    // 获得滑动条ID
    this.get_id = function () {
        if (0 === mc_slider_id.length) {
            return null;
        }
        return mc_slider_id;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_slider_title = str_title;
    };

    // 设置数据的最大值
    this.set_max_val = function (cui_max_val) {
        if ('string' !== typeof cui_max_val || '' === cui_max_val) {
            return false;
        }
        mc_slider_max = cui_max_val;
    };

    // 设置数据的最小值
    this.set_min_val = function (cui_min_val) {
        if ('string' !== typeof cui_min_val || '' === cui_min_val) {
            return false;
        }
        mc_slider_min = cui_min_val;
    };

    // 创建标签
    this.get_html_txt = function () {
        mc_slider_id = mc_get_id();
        // 轨道 div滑块 inp滑块 class类
        var str_class_list_slider = '';
        var str_class_list_dthumb = '';
        var str_class_list_ithumb = '';

        for (var idx_class_slider = 0; idx_class_slider < ary_class[0].length; idx_class_slider++) {
            str_class_list_slider += ary_class[0][idx_class_slider] + ' ';
        }


        for (var idx_class_dthumb = 0; idx_class_dthumb < ary_class[1].length; idx_class_dthumb++) {
            str_class_list_dthumb += ary_class[1][idx_class_dthumb] + ' ';
        }


        for (var idx_class_ithumb = 0; idx_class_ithumb < ary_class[2].length; idx_class_ithumb++) {
            str_class_list_ithumb += ary_class[2][idx_class_ithumb] + ' ';
        }


        str_class_list_slider = str_class_list_slider.trim();
        str_class_list_dthumb = str_class_list_dthumb.trim();
        str_class_list_ithumb = str_class_list_ithumb.trim();

        // 样式
        if (0 !== ary_style[0].length) {
            var str_style_list = '';
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ':' + ary_style[0][idx_style][1] + ';'
            }
            str_style_list = str_style_list.trim();
        }

        if (0 !== ary_style[1].length) {
            var str_style_list_thumb = '';
            for (var idx_style = 0; idx_style < ary_style[1].length; idx_style++) {
                str_style_list_thumb += ary_style[1][idx_style][0] + ':' + ary_style[1][idx_style][1] + ';'
            }
            str_style_list_thumb = str_style_list_thumb.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = '';
        if (typeof this.on_val_chg === 'function') {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_name(this.on_val_chg) + "'";
        }
        return str_dom_txt = "<div id='" + mc_slider_id + "' class='" + str_class_list_slider + "' title='" + mc_slider_title + "'><div class='mc_slider_min'>" + mc_slider_min + "</div><div class='mc_slider_max'>" + mc_slider_max + "</div><div " + str_val_chg_callback_attr + " class='" + str_class_list_dthumb + "'></div><input type='text' class='" + str_class_list_ithumb + "' /></div>"
    };
};

// 下拉列表框
function mc_ui_option() {
    var mc_select_id = ""; //id
    var mc_select_val = []; //下拉列表值
    var mc_select_title = ""; //title值
    var mc_select_default = ""; // 默认值
    var ary_class = ['mc_opt_select'];
    var ary_style = [
        [],
        []
    ]; //样式通过添加类来修改 输入框宽高 下拉菜单背景颜色、字体大小

    this.on_val_chg = function () {};

    // 设置添加class类 
    this.set_add_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
    };

    // 移除calss类
    this.set_del_css = function (str_css) {
        if ('string' !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
    };

    // 设置下拉列表的内容
    this.set_arr = function (arr_val) {
        if ('object' !== typeof arr_val || 0 === arr_val.length) {
            return false;
        }
        mc_select_val = arr_val;
    };

    // 设置title 
    this.set_title = function (str_title) {
        mc_select_title = str_title;
    };

    // 设置默认值 idx_default默认值下标
    this.set_val = function (idx_default) {
        mc_select_default = mc_select_val.slice(idx_default, idx_default + 1).join('');
    };

    // 创建标签
    this.get_html_txt = function () {
        mc_select_id = mc_get_id();
        var str_class_list = '';
        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + ' ';
        }
        str_class_list = str_class_list.trim();

        // 循环下拉列表值创建列表字串
        var str_val_list = '';
        for (var idx_val = 0; idx_val < mc_select_val.length; idx_val++) {
            str_val_list += "<option value='" + mc_select_val[idx_val] + "'>" + mc_select_val[idx_val] + "</option>"
        }

        // 触发回调函数
        var str_val_chg_callback_attr = '';
        if (typeof this.on_val_chg === 'function') {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_name(this.on_val_chg) + "'";
        }
        return str_dom_txt = "<select id='" + mc_select_id + "' class='" + str_class_list + "'  mc_select_default=" + mc_select_default + " name='state' " + str_val_chg_callback_attr + ">" + str_val_list + "</select>";
    };


};


/********功能函数*********************************************************************************
/**
 * 功能：编辑框 input 效验 
 * 参数：@param {*} obj 事件传递
 * 举例：onkeyup="mc_setinp_int(this)"
 */
// 整数
function mc_setinp_int(obj) {
    // 去掉非数字 除了数字和-
    obj.value = obj.value.replace(/[^\d-]/g, '');
    // 0 不开头
    obj.value = obj.value.replace(/^0/, '');
};

// 正整数
function mc_setinp_uint(obj) {
    // 去掉非数字 
    obj.value = obj.value.replace(/[^\d]/g, '');
    // 0 不开头
    obj.value = obj.value.replace(/^0/, '');
};

// 十六进制数
function mc_setinp_hex(obj) {
    // 去掉除了 A-F 0-9 
    obj.value = obj.value.replace(/[^\dA-F]/g, '');
};

// 浮点数和整数
function mc_setinp_flost(obj) {
    // 保证第一个为数字而不是.
    obj.value = obj.value.replace(/^\./g, "");
    //先把非数字的都替换掉,处理数字和.
    obj.value = obj.value.replace(/[^\d.-]/g, "");
    //保证只有出现一个.而没有多个.
    obj.value = obj.value.replace(/\.{2,}/g, ".");
    // 0 不开头
    // obj.value = obj.value.replace(/^0/, '');
    // 保留两位小数
    obj.value = obj.value.replace(/^(\-)*(\d+)\.(\d\d).*$/, '$1$2.$3');
};

// 接受所有可见字符
function mc_setinp_(obj) {
    obj.value = obj.value;
};

/********取出函数名*********************************************************************************/
function mc_get_func_name(func) {
    var regExp = /function\s*\w*\(([\s\S]*?)\)/;
    var func_name = func.toString().split("(")[0].split(" ")[1];
    return func_name
}

/********编辑框最大最小值设定*********************************************************************************/

function mc_item_js_fun() {
    // 中部滚动条
    $('.mc_opt_select').select2(); // 初始化下拉菜单

    $('.mc_edt_inp_wrap').on('change', '.mc_edit', function () {
        // 获得最大最小值
        var cui_max_val = $(this).attr('cui_max_val');
        var cui_min_val = $(this).attr('cui_min_val');
        // 数据类型转换
        var edit_val_int = parseInt($(this).val());
        edit_val_int < parseInt(cui_max_val) ? edit_val_int : $(this).val(parseInt(cui_max_val));
        edit_val_int > parseInt(cui_min_val) ? edit_val_int : $(this).val(parseInt(cui_min_val));

        // 将当前id与新的值返回
        var str_fun_name = $(this).attr(g_str_attr_lab_val_chg);
        if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
            var str_id = $(this).attr('id');
            var str_val = $(this).val();
            eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
        }
    });

    /********步进编辑框设定*********************************************************************************/
    $('.mc_edt_inp_wrap').on('click', '.mc_step_add', function () {
        // inp值获取
        var inp_val = $(this).prev().val();
        // 获取最大值
        var cui_max_val = $(this).attr('cui_max_val');
        // 获取步进值
        var cui_step = $(this).prev().attr('cui_step');
        // 判断步进值是否为小数 转换类型
        if (cui_step.indexOf('.') === -1) {
            parseInt(inp_val) < parseInt(cui_max_val) ? $(this).prev().val(parseInt(inp_val) + parseInt(cui_step)) : $(this).prev().val(parseInt(cui_max_val));
        } else {
            // 浮点型保留两位小数
            parseFloat(inp_val) < parseFloat(cui_max_val) ? $(this).prev().val((parseFloat(inp_val) + parseFloat(cui_step)).toFixed(2)) : $(this).prev().val(parseFloat(cui_max_val));
        }

        // 将当前id与新的值返回
        var str_fun_name = $(this).prev().attr(g_str_attr_lab_val_chg);
        if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
            var str_id = $(this).prev().attr('id');
            var str_val = $(this).prev().val();
            eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
        }
    });

    // 步进编辑框 减
    $('.mc_edt_inp_wrap').on('click', '.mc_step_sub', function () {
        var inp_val = $(this).next().val();
        // 获取最小值
        var cui_min_val = $(this).attr('cui_min_val');
        // 步进值获取
        var cui_step = $(this).next().attr('cui_step');
        // 判断步进值是否为小数 转换类型
        if (cui_step.indexOf('.') === -1) {
            parseInt(inp_val) > parseInt(cui_min_val) ? $(this).next().val(parseInt(inp_val) - parseInt(cui_step)) : $(this).next().val(parseInt(cui_min_val));
        } else {
            parseFloat(inp_val) > parseFloat(cui_min_val) ? $(this).next().val((parseFloat(inp_val) - parseFloat(cui_step)).toFixed(2)) : $(this).next().val(parseFloat(cui_min_val));
        }

        var str_fun_name = $(this).next().attr(g_str_attr_lab_val_chg);
        if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
            var str_id = $(this).next().attr('id');
            var str_val = $(this).next().val();
            eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
        }
    });

    /********复选框点击添加勾选class类*********************************************************************************/
    $('.mc_edt_inp_wrap').on('click', '.mc_checkbox_box', function () {
        var mc_checkbox = $(this).children('.mc_checkbox');
        // 判断是否选中 ture false 
        var str_val = false;
        if (mc_checkbox.hasClass('mc_checkbox_true')) {
            mc_checkbox.removeClass('mc_checkbox_true');
        } else {
            mc_checkbox.addClass('mc_checkbox_true');
            str_val = true;
        }

        // 将当前id与新的值返回
        var str_fun_name = $(this).attr(g_str_attr_lab_val_chg);
        if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
            var str_id = $(this).attr('id');
            eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
        }
    });

    /********滑动条*********************************************************************************/
    // $(".mc_slider_thumb").drag();
    // 滑块移动的当前位置
    var slider_thumb_inp_left = '';
    // 滑动条
    $.fn.extend({
        drag: function () {
            $(this).mousedown(function (e) {
                // 父元素/轨道的宽
                var mc_slider_width = $(this).parent().width();
                // 父元素相对于屏幕左侧的距离
                var toLeft = $(this).parent().offset().left;
                var $this = $(this);
                $(document).bind('mousemove', function (e) {
                    var left = (e.clientX - toLeft) / (mc_slider_width) * 100;

                    if (left < 0.6) {
                        left = 0
                    }
                    if (left > 99.9) {
                        left = 100
                    }

                    // 记录当前位置
                    slider_thumb_inp_left = left;

                    if (left <= 100 && left >= 0) {
                        $this.css({
                            'left': slider_thumb_inp_left + '%',
                        }).text(left.toFixed(2));
                    }
                })

                $(document).mouseup(function () {

                    $(document).unbind('mousemove');
                    // 将当前id与新的值返回
                    var str_fun_name = $this.attr(g_str_attr_lab_val_chg);
                    if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
                        var str_id = $this.parent().attr('id');
                        var str_val = $this.text();
                        eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
                    }
                });
                return false; //阻止默认事件 
            });
        }
    });

    // 双击滑块将div更改为inp
    $('.mc_edt_inp_wrap').on('dblclick', '.mc_slider_thumb', function (e) {
        $(this).css('display', 'none');
        $(this).next().css({
            'display': 'block',
            'left': slider_thumb_inp_left + '%'
        }).val('');
    });

    // inp失去光标 做相应滑动
    $('.mc_edt_inp_wrap').on('blur', '.mc_slider_thumb_inp', function () {
        var thumb_inp_val = $(this).val();
        console.log(thumb_inp_val)
        if (thumb_inp_val <= 100 && thumb_inp_val >= 0) {
            $(this).animate({
                    'left': thumb_inp_val + '%'
                }, 500,
                function () {
                    // 记录当前inp位置
                    slider_thumb_inp_left = thumb_inp_val;
                    $(this).prev().css({
                        'display': 'block',
                        'left': slider_thumb_inp_left + '%'
                    }).text(slider_thumb_inp_left).next().css('display', 'none');
                    var str_fun_name = $(this).prev().attr(g_str_attr_lab_val_chg);
                    if (typeof str_fun_name === 'string' && 0 < str_fun_name.length) {
                        var str_id = $(this).parent().attr('id');
                        var str_val = $(this).prev().text();
                        eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
                    }
                });
        } else {
            thumb_inp_val = $(this).val('')
        }
    });

    /********初始化下拉框*********************************************************************************/
    $(document).ready(function () {
        var select_default = $('.mc_opt_select').attr('mc_select_default');
        // 修改默认值
        $('.mc_opt_select').select2()[0].value = select_default;
        $('.mc_opt_select').select2();
    });

    // 当 mc_wrap 滚动时 将下拉菜单收起
    $('.mc_wrap').niceScroll().scrollstart(function () {
        $('.mc_opt_select').select2('close');
    })

    // 返回当前选择的id和值
    $(".mc_edt_inp_wrap").on("select2:close", '.mc_opt_select', function () {
        var str_fun_name = $(this).attr(g_str_attr_lab_val_chg);
        if ('string' === typeof str_fun_name && 0 < str_fun_name.length) {
            var str_id = $(this).attr('id');
            var str_val = $(this).select2()[0].value;
            eval(str_fun_name + "('" + str_id + "','" + str_val + "')");
        }
    });

}